% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_fit.R
\name{clean_fit_glm}
\alias{clean_fit_glm}
\title{Fit a stats::glm without carying back large structures.}
\usage{
clean_fit_glm(outcome, variables, data, ..., family, intercept = TRUE,
  outcome_target = NULL, outcome_comparator = "==", weights = NULL,
  env = baseenv())
}
\arguments{
\item{outcome}{character, name of outcome column.}

\item{variables}{character, names of varaible columns.}

\item{data}{data.frame, training data.}

\item{...}{not used, force later arguments to be used by name}

\item{family}{passed to stats::glm()}

\item{intercept}{logical, if TRUE allow an intercept term.}

\item{outcome_target}{scalar, if not NULL write outcome==outcome_target in formula.}

\item{outcome_comparator}{one of "==", "!=", ">=", "<=", ">", "<", only use of outcome_target is not NULL.}

\item{weights}{passed to stats::glm()}

\item{env}{environment to work in.}
}
\value{
list(model=model, summary=summary)
}
\description{
Please see \url{http://www.win-vector.com/blog/2014/05/trimming-the-fat-from-glm-models-in-r/} for discussion.
}
\examples{

mk_data_example <- function(k) {
  data.frame(
    x1 = rep(c("a", "a", "b", "b"), k),
    x2 = rep(c(0, 0, 0, 1), k),
    y = rep(1:4, k),
    yC = rep(c(FALSE, TRUE, TRUE, TRUE), k),
    stringsAsFactors = FALSE)
}

res_glm <- clean_fit_glm("yC", c("x1", "x2"),
                         mk_data_example(1),
                         family = binomial)
length(serialize(res_glm$model, NULL))

res_glm <- clean_fit_glm("yC", c("x1", "x2"),
                         mk_data_example(10000),
                         family = binomial)
length(serialize(res_glm$model, NULL))

predict(res_glm$model,
        newdata = mk_data_example(1),
        type = "response")

}
