% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmf_methods.R
\name{wmf_methods}
\alias{wmf_methods}
\alias{summary.wmf}
\alias{print.wmf}
\alias{set_times.wmf}
\alias{set_timescales.wmf}
\alias{set_values.wmf}
\alias{set_dat.wmf}
\alias{set_wtopt.wmf}
\alias{get_times.wmf}
\alias{get_timescales.wmf}
\alias{get_values.wmf}
\alias{get_dat.wmf}
\alias{get_wtopt.wmf}
\title{Basic methods for the \code{wmf} class}
\usage{
\method{summary}{wmf}(object, ...)

\method{print}{wmf}(x, ...)

\method{set_times}{wmf}(obj, newval)

\method{set_timescales}{wmf}(obj, newval)

\method{set_values}{wmf}(obj, newval)

\method{set_dat}{wmf}(obj, newval)

\method{set_wtopt}{wmf}(obj, newval)

\method{get_times}{wmf}(obj)

\method{get_timescales}{wmf}(obj)

\method{get_values}{wmf}(obj)

\method{get_dat}{wmf}(obj)

\method{get_wtopt}{wmf}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{wmf}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.wmf} produces a summary of a \code{wmf} object.
A \code{print.wmf} method is also available. For \code{wmf} objects, 
\code{set_*} and \code{get_*} methods are available for all slots,
i.e., \code{*} equal to \code{times}, \code{timescales}, \code{wtopt}, 
\code{values}, and \code{dat}. The \code{set_*} methods just throw an 
error, to prevent breaking the consistency between the slots of a 
\code{wmf} object.
}
\description{
Set, get, summary, and print methods for the \code{wmf} class.
}
\examples{
times<-1:30 #generate time steps
#generate fake count data for 20 locations
dat<-matrix(rpois(20*length(times),20),nrow=20,ncol=length(times)) 
dat<-cleandat(dat=dat,times=times,clev=2)$cdat #detrend and demean
h<-wmf(dat,times)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{wmf}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
