% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_qtlSpecificity}
\alias{xQTLvisual_qtlSpecificity}
\title{Visualization of QTL specificity among multiple cells/tissues.}
\usage{
xQTLvisual_qtlSpecificity(
  specificityDT,
  outPlot = "heatmap",
  binNum = 4,
  topTissues = 5
)
}
\arguments{
\item{specificityDT}{A data.table object from the function \code{xQTLanalyze_qtlSpecificity}}

\item{outPlot}{(character) options: "heatmap" (default) and "regression".}

\item{binNum}{(numeric) number of LD bins for heatmap plot. Default:4.}

\item{topTissues}{(numeric) number of top tissues that sorted with slope increasingly to visualize for regression plot. Default: 5}
}
\value{
A ggplot object
}
\description{
Visualization of QTL specificity among multiple cells/tissues.
}
\examples{
\donttest{
speDT <- xQTLanalyze_qtlSpecificity(gene="MMP7", variantName="rs11568818", study="")
xQTLvisual_qtlSpecificity(speDT, outPlot = "heatmap")
xQTLvisual_qtlSpecificity(speDT, outPlot = "regression")
}
}
