% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_locusZoom}
\alias{xQTLvisual_locusZoom}
\title{Locuszoom plot for visualizing regional signals relative to genomic position with a file of summary statistics}
\usage{
xQTLvisual_locusZoom(
  DF,
  highlightSnp = "",
  population = "EUR",
  posRange = "",
  legend = TRUE,
  legend_position = c("topright", "bottomright", "topleft"),
  snpLD = NULL
)
}
\arguments{
\item{DF}{A data.frame or a data.table object. Four columns are required (arbitrary column names is supported):

\verb{Col 1}. "snps" (character), , using an rsID (e.g. "rs11966562");

\verb{Col 2}. "chromosome" (character), one of the chromosome from chr1-chr22;

\verb{Col 3}. "postion" (integer), genome position of snp.

\verb{Col 4}. "P-value" (numeric).}

\item{highlightSnp}{Default is the snp that with lowest p-value.}

\item{population}{One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.}

\item{posRange}{Genome range that you want to visualize (e.g. "chr6:3e7-7e7"). Default is the region that covers all snps.}

\item{legend}{(boolean, optional) Should the legend be shown? Default: TRUE.}

\item{legend_position}{(string, optional) Either 'bottomright','topright', or 'topleft'. Default: 'bottomright'.}

\item{snpLD}{A data.frame of LD matirx. Default is null.}
}
\value{
A list containing data.table and ggplot object.
}
\description{
This function is rebuilt from \code{locuscompare.R} (https://github.com/boxiangliu/locuscomparer/blob/master/R/locuscompare.R).
}
\examples{
\donttest{
library(data.table)
# For GWAS dataset:
gwasDF <- fread("https://gitee.com/stronghoney/exampleData/raw/master/gwasChr6Sub4.txt")
xQTLvisual_locusZoom(gwasDF)
# Zoom in:
xQTLvisual_locusZoom(gwasDF, posRange="chr6:4.7e7-4.8e7", population ="EUR")

# For eQTL of a gene of interest (time-consuming):
eqtlAsso <- xQTLdownload_eqtlAllAsso("RP11-385F7.1", tissueLabel = "Brain - Cortex",
                                     withB37VariantId=FALSE)
xQTLvisual_locusZoom(eqtlAsso[,c("snpId", "chrom", "pos", "pValue")], highlightSnp="rs4711878" )
# Zoom in:
xQTLvisual_locusZoom(eqtlAsso[,c("snpId", "chrom", "pos", "pValue")], highlightSnp="rs4711878",
                     posRange="chr6:47.3e6-47.9e6")
}
}
