% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCCC.R
\name{extractCCC}
\alias{extractCCC}
\title{Extract chromatic coefficients and their statistics}
\usage{
extractCCC(path, m)
}
\arguments{
\item{path}{a character string, path to the JPEG file}

\item{m}{a binary mask, mask binary matrix (0 for included, 1 for not)}
}
\value{
The function returns statistical metrics for each color channel. It returns NULL, if dimensions do not agree.
}
\description{
This function applies a mask matrix to a jpeg image and extract statstical metrics for each chromatic coordinate on R, G and B.
}
\examples{

m <- tiff::readTIFF(system.file(package = 'xROI', 'dukehw-mask.tif'))
jpgFile <- system.file(package = 'xROI', 'dukehw.jpg')
cc <- extractCCC(jpgFile, m)
}
\keyword{bcc}
\keyword{chromatic}
\keyword{coordinates}
\keyword{exract}
\keyword{gcc}
\keyword{rcc}
