% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{tinify}
\alias{tinify}
\title{Use the Tinify API to compress PNG and JPEG images}
\usage{
tinify(
  input,
  output,
  quiet = FALSE,
  force = FALSE,
  key = getOption("xfun.tinify.key", Sys.getenv("R_XFUN_TINIFY_KEY")),
  history = getOption("xfun.tinify.history", Sys.getenv("R_XFUN_TINIFY_HISTORY"))
)
}
\arguments{
\item{input}{A vector of input paths of images.}

\item{output}{A vector of output paths or a function that takes \code{input}
and returns a vector of output paths (e.g., \code{output = \link{identity}}
means \code{output = input}). By default, if the \code{history} argument is
not a provided, \code{output} is \code{input} with a suffix \code{-min}
(e.g., when \code{input = 'foo.png'}, \code{output = 'foo-min.png'}),
otherwise \code{output} is the same as \code{input}, which means the
original image files will be overwritten.}

\item{quiet}{Whether to suppress detailed information about the compression,
which is of the form \samp{input.png (10 Kb) ==> output.png (5 Kb, 50\%);
compression count: 42}. The percentage after \code{output.png} stands for
the compression ratio, and the compression count shows the number of
compressions used for the current month.}

\item{force}{Whether to compress an image again when it appears to have been
compressed before. This argument only makes sense when the \code{history}
argument is provided.}

\item{key}{The Tinify API key. It can be set via either the global option
\code{xfun.tinify.key} (you may set it in \file{~/.Rprofile}) or the
environment variable \code{R_XFUN_TINIFY_KEY} (you may set it in
\file{~/.Renviron}).}

\item{history}{Path to a history file to record the MD5 checksum of
compressed images. If the checksum of an expected output image exists in
this file and \code{force = FALSE}, the compression will be skipped. This
can help you avoid unnecessary API calls.}
}
\value{
The output file paths.
}
\description{
Compress PNG/JPEG images with \samp{api.tinify.com}, and download the
compressed images. This function requires R packages \pkg{curl} and
\pkg{jsonlite}.
}
\details{
You are recommended to set the API key in \file{.Rprofile} or
\file{.Renviron}. After that, the only required argument of this function is
\code{input}. If the original images can be overwritten by the compressed
images, you may either use \code{output = identity}, or set the value of the
\code{history} argument in \file{.Rprofile} or \file{.Renviron}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
f = file.path(R.home("doc"), "html", "logo.jpg")
xfun::tinify(f)  # remember to set the API key before trying this
\dontshow{\}) # examplesIf}
}
\references{
Tinify API: \url{https://tinypng.com/developers}.
}
\seealso{
The \pkg{tinieR} package (\url{https://github.com/jmablog/tinieR/})
  is a more comprehensive implementation of the Tinify API, whereas
  \code{xfun::tinify()} has only implemented the feature of shrinking images.
}
