% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{file_ext}
\alias{file_ext}
\alias{sans_ext}
\alias{with_ext}
\title{Manipulate filename extensions}
\usage{
file_ext(x, extra = "")

sans_ext(x, extra = "")

with_ext(x, ext, extra = "")
}
\arguments{
\item{x}{A character of file paths.}

\item{extra}{Extra characters to be allowed in the extensions. By default,
only alphanumeric characters are allowed (and also some special cases in
\sQuote{Details}). If other characters should be allowed, they can be
specified in a character string, e.g., \code{"-+!_#"}.}

\item{ext}{A vector of new extensions. It must be either of length 1, or the
same length as \code{x}.}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
Functions to obtain (\code{file_ext()}), remove (\code{sans_ext()}), and
change (\code{with_ext()}) extensions in filenames.
}
\details{
\code{file_ext()} is similar to \code{\link[tools:fileutils]{tools::file_ext()}}, and
\code{sans_ext()} is similar to \code{\link[tools:fileutils]{tools::file_path_sans_ext()}}.
The main differences are that they treat \code{tar.(gz|bz2|xz)} and
\code{nb.html} as extensions (but functions in the \pkg{tools} package
doesn't allow double extensions by default), and allow characters \code{~}
and \verb{#} to be present at the end of a filename.
}
\examples{
library(xfun)
p = c("abc.doc", "def123.tex", "path/to/foo.Rmd", "backup.ppt~", "pkg.tar.xz")
file_ext(p)
sans_ext(p)
with_ext(p, ".txt")
with_ext(p, c(".ppt", ".sty", ".Rnw", "doc", "zip"))
with_ext(p, "html")

# allow for more characters in extensions
p = c("a.c++", "b.c--", "c.e##")
file_ext(p)  # -/+/# not recognized by default
file_ext(p, extra = "-+#")
}
