% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_scale_x_log10.R
\name{xgx_scale_x_log10}
\alias{xgx_scale_x_log10}
\title{log10 scales the x axis with a "pretty" set of breaks}
\usage{
xgx_scale_x_log10(breaks = xgx_breaks_log10, minor_breaks = NULL,
  labels = xgx_labels_log10, ...)
}
\arguments{
\item{breaks}{major breaks, default is a function defined here}

\item{minor_breaks}{minor breaks, default is a function defined here}

\item{labels}{function for setting the labels, defined here}

\item{...}{other arguments passed to
\code{\link[ggplot2:scale_continuous]{scale_x_log10}}}
}
\value{
ggplot2 compatible scale object
}
\description{
\code{xgx_scale_x_log10} is similar to
\code{\link[ggplot2:scale_continuous]{scale_x_log10}}.  
But it uses what we believe to be a nicer spacing and set of tick marks
it can be used the same as
\code{\link[ggplot2:scale_continuous]{scale_x_log10}}
}
\examples{
 
conc <- 10^(seq(-3, 3, by = 0.1))
ec50 <- 1
data <- data.frame(concentration  = conc,
                   bound_receptor = 1 * conc / (conc + ec50))
ggplot2::ggplot(data, ggplot2::aes(x = concentration, y = bound_receptor)) + 
ggplot2::geom_point() + 
  ggplot2::geom_line() + 
  xgx_scale_x_log10() +
  xgx_scale_y_reverselog10()
  
}
