% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_auto_explore.R
\name{edit_rmd_template_str}
\alias{edit_rmd_template_str}
\title{Edit a Rmd Template from xgx}
\usage{
edit_rmd_template_str(
  rmd_str = NULL,
  mapping = NULL,
  rmd_output_path = NULL,
  data_path = NULL,
  multiple_dosing = FALSE,
  pk_cmt = NULL,
  pd_cmt = NULL,
  dose_cmt = NULL,
  steady_state_day = NULL,
  time_between_doses = NULL,
  author_name = NULL,
  add_datetime = TRUE,
  show_explanation = TRUE
)
}
\arguments{
\item{rmd_str}{A character string containing the Rmd template raw characters}

\item{mapping}{A list of column name mappings from the
original (template) dataset column names
to the corresponding columns in the new dataset}

\item{rmd_output_path}{A custom output path for the generated Rmd file
(This is typically left as `NULL` in order to maintain the hierarchical directory structure of `xgx_autoexplore_output`))}

\item{data_path}{Path (as a string) to the dataset that is to be analyzed}

\item{multiple_dosing}{if FALSE use single ascending dose template, if TRUE use multiple}

\item{pk_cmt}{An integer denoting the "compartment" containing the PK data. The "CMT" column will typically
have these integers, where each row may contain either PK or PD data, potentially of different types (continuous, ordinal, etc.)}

\item{pd_cmt}{An integer denoting the "compartment" containing the PD data, of the desired type  (continuous, ordinal, etc.). The "CMT" column will typically
have these integers, where each row may contain either PK or PD data}

\item{dose_cmt}{CMT associated with dosing event}

\item{steady_state_day}{For multiple ascending dose, what day is steady state rich profile?}

\item{time_between_doses}{time interval between doses}

\item{author_name}{The name of the author to be displayed on the template}

\item{add_datetime}{Boolean indicating additon of a date stamp to the beginnning of the Rmd file}

\item{show_explanation}{Boolean indicating if the additional explanations (text in between figures) are needed for the user.}
}
\value{
A string of the new R markdown template
}
\description{
\code{edit_rmd_template_str} returns a path to the altered Rmd template
}
