% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_save.R
\name{xgx_save}
\alias{xgx_save}
\title{Saving plot, automatically annotating the status and denoting the filenames}
\usage{
xgx_save(
  width,
  height,
  dirs = NULL,
  filename_main = NULL,
  status = "DRAFT",
  g = ggplot2::last_plot(),
  filetype = "png",
  status_x = Inf,
  status_y = Inf,
  status_fontsize = 7,
  status_fontcolor = "grey",
  filenames_fontsize = 11,
  filenames_fontcolor = "black"
)
}
\arguments{
\item{width}{width of plot}

\item{height}{height of plot}

\item{dirs}{list of directories.  If NULL or if directories missing, there 
is default behavior below

\enumerate{
\item parent_dir  = Parent directory containing the Rscript and the Results 
folder, default getwd()
\item rscript_dir = Subdirectory of parent_dir that contains the Rscript 
used to generate the figure, default "./"
\item rscript_name= Name of the Rscript used to generate the figure, 
default "Name_Of_Script_Here.R"
\item results_dir = Subdirectory ofparent_dir where the figure is stored, 
default "./"
\item filename_prefix = prefix of filename to be appended to filename_main
}}

\item{filename_main}{main part of the filename, excluding prefix and suffix.
no default}

\item{status}{status to be annotated}

\item{g}{ggplot plot object, default is ggplot::last_plot()}

\item{filetype}{file extension (e.g. "pdf","csv" etc.)}

\item{status_x}{x location of the status in plot}

\item{status_y}{y location of the status in plot}

\item{status_fontsize}{font size for status in plot}

\item{status_fontcolor}{font color for status in plot}

\item{filenames_fontsize}{font size for filenames info in plot}

\item{filenames_fontcolor}{font color for filenames info in plot}
}
\value{
ggplot2 plot object
}
\description{
Saving plot, automatically annotating the status and denoting the filenames
}
\examples{
directory = tempdir()
dirs <- list(parent_dir  = directory,
             rscript_dir = directory,
             rscript_name = "example.R",
             results_dir = directory,
             filename_prefix = "example_")
data <- data.frame(x = 1:1000, y = stats::rnorm(1000))
ggplot2::ggplot(data = data, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_point()
xgx_save(4, 4, dirs, "Example", "DRAFT")

}
