% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.xhaz.bsplines.R
\name{summary.bsplines}
\alias{summary.bsplines}
\title{A summary.bsplines Function used to print a object of class \code{bsplines}}
\usage{
\method{summary}{bsplines}(object, ...)
}
\arguments{
\item{object}{an object of class \code{bsplines}}

\item{...}{additionnal parameters which can be used in the \code{summary}
function}
}
\value{
Estimated parameters of the model in different scales for interpretation purposes.
}
\description{
This function present the estimated coefficients for the excess
hazard baseline coefficient and for the covariate effects
}
\examples{

\donttest{
library("xhaz")
library("survival")
library("numDeriv")
library("survexp.fr")
library("splines")

data("dataCancer", package = "xhaz")   # load the data set in the package

fit.phBS <- xhaz(
              formula = Surv(obs_time_year, event) ~ ageCentre + immuno_trt,
              data = dataCancer, ratetable = survexp.fr,
              interval = c(0, NA, NA, max(dataCancer$obs_time_year)),
              rmap = list(age = 'age', sex = 'sexx', year = 'year_date'),
              baseline = "bsplines", pophaz = "classic")

summary(fit.phBS)
}

}
\references{
Goungounga JA, Touraine C, Grafféo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Touraine C, Grafféo N, Giorgi R; CENSUR working survival group.
More accurate cancer-related excess mortality through correcting
background mortality for extra variables.
Stat Methods Med Res. 2020 Jan;29(1):122-136.
doi: 10.1177/0962280218823234. Epub 2019 Jan 23. PMID: 30674229.
(\href{https://pubmed.ncbi.nlm.nih.gov/30674229/}{PubMed})

Mba RD, Goungounga JA, Grafféo N, Giorgi R; CENSUR working survival group.
Correcting inaccurate background mortality in excess hazard models
through breakpoints. BMC Med Res Methodol. 2020 Oct 29;20(1):268.
doi: 10.1186/s12874-020-01139-z. PMID: 33121436; PMCID: PMC7596976.
(\href{https://pubmed.ncbi.nlm.nih.gov/33121436/}{PubMed})
}
\seealso{
\code{\link{xhaz}}, \code{\link{summary.bsplines}}, \code{\link{plot.bsplines}}
}
\keyword{summary.bsplines}
