% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_question_block_table.R
\name{build_qtable}
\alias{build_qtable}
\title{Summarise a question block}
\usage{
build_qtable(
  x,
  block_cols,
  cols = NULL,
  table_title = "",
  use_questions = FALSE,
  use_NA = FALSE,
  wt = NULL,
  footnote = ""
)
}
\arguments{
\item{x}{a data frame or tidy object}

\item{block_cols}{<\link[tidyr]{tidyr_tidy_select}> statement. These are the
columns that make up the question block, they must have the same response
option. Most question block columns start with the same piece of text, so
you should use \code{starts_with('column_text')}. See the Examples below.}

\item{cols}{<\link[tidyr]{tidyr_tidy_select}> statement. These are the column(s) that we
want to cut the questions in the question block by.}

\item{table_title}{a string. The title of the table sheet}

\item{use_questions}{a logical. If the data has column labels (was a imported .sav)
file, convert the column label to a footnote with the question.}

\item{use_NA}{a logical. Whether to include \code{NA} values in the table. For more complicated
\code{NA} processing post creation, we recommend using filter.}

\item{wt}{a quoted or unquote column name. Specify a weighting variable, if
\code{NULL} no weight is applied.}

\item{footnote}{a character vector. Optional parameter to pass a custom
footnote to the question, this parameter overwrites \code{use_questions}.}
}
\value{
a \code{xlr_table} object. Use \link{write_xlsx} to write to an \code{Excel} file.
See \link{xlr_table} for more information.
}
\description{
This function helps analyse a block of questions or matrix questions into a
single table. It also lets the user cut these questions by other questions in
the data. The block of questions mush have the same response options.
}
\details{
This function and its family (\link{build_table}, \link{build_qtable}) is designed to
work with data with columns of type \code{haven::labelled},
which is the default format of data read with \code{haven::read_sav}/has the format
of \code{.sav}. \code{.sav} is the default file function type of data from \code{SPSS} and
can be exported from popular survey providers such as Qualtrics. When you
read in data with \code{haven::read_sav} it imports data with the questions,
labels for the response options etc.

By default this function converts \link[haven]{labelled} to a \link{xlr_vector}
by default (and underlying it is a \code{character()} type).

See \link[haven]{labelled} and \link[haven]{read_sav} if you would like more
details on the importing type.
}
\examples{
library(xlr)

# You can use this function to get a block of questions
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  table_title = "This is an example table")

# Another way you could select the same columns
build_qtable(
  clothes_opinions,
  c(Q1_1,Q1_2,Q1_3,Q1_4),
  table_title = "This is an example table")

# Yet another way to select the same columns
build_qtable(
  clothes_opinions,
  all_of(c("Q1_1","Q1_2","Q1_3","Q1_4")),
  table_title = "This is an example table")
# You can also cut all questions in the block by a single column
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  gender2,
  table_title = "This is the second example table")

# You can also cut all questions in the block by a multiple columns
# By setting `use_questions=TRUE` then the footnote will be the questions
# labels, for the cut questions
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  c(gender2,age_group),
  table_title = "This is the third example table",
  use_questions = TRUE)

# You can also use weights, these weights can be either doubles or integers
# based weights
# You can also set a footnote
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  age_group,
  table_title = "This is the fourth example table",
  wt = weight,
  footnote = paste0("This is a footnote, you can use it if you want ",
                    "more detail in your table."))
}
