% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table}
\alias{build_table}
\title{Create a one, two, three,..., n-way table}
\usage{
build_table(
  x,
  cols,
  table_title = "",
  use_questions = FALSE,
  use_NA = FALSE,
  wt = NULL,
  footnote = ""
)
}
\arguments{
\item{x}{a data frame or tidy object.}

\item{cols}{<\link[tidyr]{tidyr_tidy_select}> These are the column(s) that we
want to calculate the count and percentage of.}

\item{table_title}{a string. The title of the table sheet.}

\item{use_questions}{a logical. If the data has column labels convert the
column label to a footnote with the question. See details for more information.}

\item{use_NA}{a logical. Whether to include \code{NA} values in the table. For more complicated
\code{NA} processing post creation, we recommend using filter.}

\item{wt}{a quoted or unquote column name. Specify a weighting variable, if
\code{NULL} no weight is applied.}

\item{footnote}{a character vector. Optional parameter to pass a custom
footnote to the question, this parameter overwrites \code{use_questions}.}
}
\value{
a \code{xlr_table} object. Use \link{write_xlsx} to write to an \code{Excel} file.
See \link{xlr_table} for more information.
}
\description{
\code{build_table} creates a one, two, three, ..., n-way table. It should be used
to calculate the count and percentage of different categorical variables. It
gives the data back in a long format. The percentages calculated are the
'row' percentages.
}
\details{
This function and its family (\link{build_mtable}, \link{build_qtable}) is designed to
work with data with columns of type \code{haven::labelled},
which is the default format of data read with \code{haven::read_sav}/has the format
of \code{.sav}. \code{.sav} is the default file function type of data from \code{SPSS} and
can be exported from popular survey providers such as Qualtrics. When you
read in data with \code{haven::read_sav} it imports data with the questions,
labels for the response options etc.

By default this function converts \link[haven]{labelled} to a \link{xlr_vector}
by default (and underlying it is a \code{character()} type).

See \link[haven]{labelled} and \link[haven]{read_sav} if you would like more
details on the importing type.
}
\examples{
library(xlr)

# You can use this function to calculate the number count and percentage
# of a categorical variable
build_table(
  clothes_opinions,
  gender,
  table_title = "The count of the gender groups")

# You must use a `tidyselect` statement, to select the columns that you wish to
# calculate the count, and group percentage.
# This will calculate the number of observations in each group of age and
# gender.
# The percentage will be the percentage of each age_group in each gender
# group (the row percentage).
build_table(
  clothes_opinions,
  c(gender,age_group),
  table_title = "This is the second example table")

# You can use more complicated tidy select statements if you have a large number
# of columns, but this is probably not recommended
#
# Using use_questions, if you have labelled data, it will take the label and
# include it as a footnote.
# This is useful for when you have exported data from survey platforms
# as a .sav, use `haven::read_sav` to load it into your R environment.
build_table(
  clothes_opinions,
  c(group:gender,Q1_1),
  table_title = "This is the third example table",
  use_questions = TRUE)

# You can also use weights, these weights can be either doubles or integers
# based weights
# You can also set a footnote manually
build_table(
  clothes_opinions,
  age_group,
  table_title = "This is the fourth example table",
  wt = weight,
  footnote = paste0("This is a footnote, you can use it if you want",
                    "more detail in your table."))


}
