% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getXLsettings.R
\name{getXLsettings}
\alias{getXLsettings}
\title{Get Default Excel cell styles}
\usage{
getXLsettings(fname = NA)
}
\arguments{
\item{fname}{Excel file name}
}
\value{
list with workbook and default cell styles
}
\description{
Get Default Excel cell styles
}
\details{
If no Excel file is specified then the built in cell styles are used.
  User-supplied Excel file would need to have the following cell styles
  specified: xl.descrip, xl.normal, xl.header, xl.header.wrap, xl.hyperlink.
}
\examples{
XL.wb <- getXLsettings()
XL.wb <- addXLsheetStd(XL.wb, mtcars)
XL.wb <- addXLsheetStd(XL.wb, mtcars, "mtcars1")
XL.wb <- addXLsheetStd(XL.wb, mtcars, "mtcars2", "Standard mtcars data frame")
XL.wb$pName <- "ProjName" # optional, blank if not included
XL.wb$pDesc <- "ProjDesc" # optional, blank if not included
saveXLworkbook(XL.wb, 'myXLfile.xlsx', timeStamp=FALSE, clean=FALSE)
saveXLworkbook(XL.wb, 'myXLfile.xlsx', timeStamp=TRUE,  clean=FALSE)
saveXLworkbook(XL.wb, 'myXLfile.xlsx', timeStamp=TRUE,  clean=TRUE)
saveXLworkbook(XL.wb, 'myXLfile.xlsx')
}
