% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{set_java_tmp_dir}
\alias{set_java_tmp_dir}
\alias{get_java_tmp_dir}
\title{Set Java Temp Directory}
\usage{
set_java_tmp_dir(tmp_dir = tempdir())

get_java_tmp_dir()
}
\arguments{
\item{tmp_dir}{optional. The new temp directory. Defaults to the R temp
directory}
}
\value{
The previous java temp directory (prior to any changes).
}
\description{
Java sets the java temp directory to `/tmp` by default. However, this is
usually not desirable in R. As a result, this function allows changing that
behavior. Further, this function is fired on package load to ensure all
temp files are written to the R temp directory.
}
\details{
On package load, we use `getOption("xlsx.tempdir", tempdir())` for the
default value, in case you want to have this value set by an option.
}
