% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kwak_coincidence.R
\name{coincidence}
\alias{coincidence}
\title{Estimate coincidence function}
\usage{
coincidence(cross, chr, window = 5, ncalc = 500)
}
\arguments{
\item{cross}{Cross object; must be a backcross.  See
\code{\link[qtl]{read.cross}} for format details.}

\item{chr}{Chromosome to consider (only one is allowed).  If missing, the
first chromosome is considered.}

\item{window}{Window size}

\item{ncalc}{Total number of points for calculations.}
}
\value{
Data frame with columns \code{distance} and \code{coincidence}.  The
input argument \code{window} is kept as an attribute.
}
\description{
Estimate coincidence function for a chromosome.
}
\examples{
map1 <- sim.map(103, n.mar=104, anchor=TRUE, include.x=FALSE, eq=TRUE)
x <- sim.cross(map1, n.ind=2000, m=6, type="bc")

out <- coincidence(x, ncalc=101)
plot(out, type="l", lwd=2, ylim=c(0, max(out[,2])))
}
\author{
Il youp Kwak
}
\seealso{
\code{\link{intensity}}, \code{\link{est.coi}}
}
\keyword{utilities}

