library(xpectr)
context("navigateTestFileAddin()")


test_that("testing navigateTestFileAddin()", {

  # Generate expectations for 'navigateTestFileAddin'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = navigateTestFileAddin,
  #   args_values = list(
  #     "selection" = list(
  #       "test_x.R",
  #       "test_x.R:33",
  #       "test_x.R:33:",
  #       "test_x.R#33",
  #       " test_x.R#33: ",
  #       "test_x.R:a33",
  #       "test_x.R#a33",
  #       "do_test_x.R:33"
  #       ),
  #     "navigate" = list(FALSE, NULL),
  #     "abs_path" = list(FALSE)
  #   ),
  #   indentation = 2,
  #   check_nulls = FALSE
  # )

  ## Testing 'navigateTestFileAddin'                                          ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing navigateTestFileAddin(selection = "test_x.R"...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- navigateTestFileAddin(selection = "test_x.R", navigate = FALSE, abs_path = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(file = "test_x.R", line_number = -1L))
  # Testing names
  expect_equal(
    names(output_19148),
    c("file", "line_number"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    2L)

  # Testing navigateTestFileAddin(selection = "test_x.R:...
  # Changed from baseline: selection = "test_x.R...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- navigateTestFileAddin(selection = "test_x.R:33", navigate = FALSE, abs_path = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "list")
  # Testing values
  expect_equal(
    output_19370,
    list(file = "test_x.R", line_number = 33L))
  # Testing names
  expect_equal(
    names(output_19370),
    c("file", "line_number"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    2L)

  # Testing navigateTestFileAddin(selection = "test_x.R:...
  # Changed from baseline: selection = "test_x.R...
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- navigateTestFileAddin(selection = "test_x.R:33:", navigate = FALSE, abs_path = FALSE)
  # Testing class
  expect_equal(
    class(output_12861),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "list")
  # Testing values
  expect_equal(
    output_12861,
    list(file = "test_x.R", line_number = 33L))
  # Testing names
  expect_equal(
    names(output_12861),
    c("file", "line_number"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    2L)

  # Testing navigateTestFileAddin(selection = "test_x.R#...
  # Changed from baseline: selection = "test_x.R...
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- navigateTestFileAddin(selection = "test_x.R#33", navigate = FALSE, abs_path = FALSE)
  # Testing class
  expect_equal(
    class(output_18304),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "list")
  # Testing values
  expect_equal(
    output_18304,
    list(file = "test_x.R", line_number = 33L))
  # Testing names
  expect_equal(
    names(output_18304),
    c("file", "line_number"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    2L)

  # Testing navigateTestFileAddin(selection = " test_x.R...
  # Changed from baseline: selection = " test_x....
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- navigateTestFileAddin(selection = " test_x.R#33: ", navigate = FALSE, abs_path = FALSE)
  # Testing class
  expect_equal(
    class(output_16417),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16417,
    type = "list")
  # Testing values
  expect_equal(
    output_16417,
    list(file = "test_x.R", line_number = 33L))
  # Testing names
  expect_equal(
    names(output_16417),
    c("file", "line_number"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16417),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16417)),
    2L)

  # Testing navigateTestFileAddin(selection = "test_x.R:...
  # Changed from baseline: selection = "test_x.R...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(navigateTestFileAddin(selection = "test_x.R:a33", navigate = FALSE, abs_path = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("line number was not a number."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing navigateTestFileAddin(selection = "test_x.R#...
  # Changed from baseline: selection = "test_x.R...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(navigateTestFileAddin(selection = "test_x.R#a33", navigate = FALSE, abs_path = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("line number was not a number."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing navigateTestFileAddin(selection = "do_test_x...
  # Changed from baseline: selection = "do_test_...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(navigateTestFileAddin(selection = "do_test_x.R:33", navigate = FALSE, abs_path = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("extracted file name must start with 'test_'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing navigateTestFileAddin(selection = "test_x.R"...
  # Changed from baseline: navigate = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(navigateTestFileAddin(selection = "test_x.R", navigate = NULL, abs_path = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'navigate': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'navigateTestFileAddin'                                 ####
  #

})
