% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrf.R
\name{predict.xrf}
\alias{predict.xrf}
\title{Draw predictions from a RuleFit xrf model}
\usage{
\method{predict}{xrf}(
  object,
  newdata,
  sparse = TRUE,
  lambda = "lambda.min",
  type = "response",
  ...
)
}
\arguments{
\item{object}{an object of class "xrf"}

\item{newdata}{data to predict on}

\item{sparse}{a logical indicating whether a sparse design matrix should be used}

\item{lambda}{the lasso penalty parameter to be applied}

\item{type}{the type of predicted value produced}

\item{...}{ignored arguments}
}
\description{
Draw predictions from a RuleFit xrf model
}
\examples{
m <- xrf(Petal.Length ~ ., iris,
         xgb_control = list(nrounds = 2, max_depth = 2),
         family = 'gaussian')
predictions <- predict(m, iris)

}
