% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_xpm}
\alias{plot_xpm}
\title{plot xpm data}
\usage{
plot_xpm(xpm_data, interpolate = FALSE)
}
\arguments{
\item{xpm_data}{a xpm object returned by read_xpm}

\item{interpolate}{logical indicating whether to use raster interpolation (TRUE)
or discrete tiles (FALSE). Default is FALSE.}
}
\value{
a ggplot2 object
}
\description{
plot xpm data using ggplot2
}
\examples{
\donttest{
library(xvm)
xpm_file_path <- system.file("extdata/gibbs.xpm", package = "xvm")
xpm_data <- read_xpm(xpm_file_path)
plot_xpm(xpm_data) # plot the xpm data using plot_xpm() function
}
}
