% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_xvg}
\alias{plot_xvg}
\title{plot xvg data}
\usage{
plot_xvg(xvg_data, title = NULL, subtitle = NULL, ...)
}
\arguments{
\item{xvg_data}{xvg data object returned by read_xvg}

\item{title}{chart title (default uses xvg file's title)}

\item{subtitle}{chart subtitle (default uses xvg file's subtitle)}

\item{...}{additional parameters passed to ggplot2::geom_line}
}
\value{
a ggplot2 object
}
\description{
plot xvg data using ggplot2
}
\examples{
\donttest{
library(xvm)
rmsd_file_path <- system.file("extdata/rmsd.xvg", package = "xvm")
rmsd_data <- read_xvg(rmsd_file_path)
plot_xvg(rmsd_data) # plot the xvg data using plot_xvg() function
}
}
