% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimations.R
\name{estimate.items}
\alias{estimate.items}
\alias{estimate.items.3pl.bme}
\alias{estimate.items.3pl.jmle}
\alias{estimate.items.3pl.mmle}
\title{Estimation of Item Parameters}
\usage{
estimate.items(responses, model = "3pl", method = "jmle", ...)

estimate.items.3pl.jmle(responses, people, fix = list(), iter = 30,
  conv = 0.01, bound = list(a = 2, b = 3.5, c = 0.25), init = list(a = 1,
  b = 0, c = 0), debug = FALSE)

estimate.items.3pl.mmle(responses, fix = list(), iter = 30, conv = 0.01,
  bound = list(a = 2, b = 3.5, c = 0.25), init = list(a = 1, b = 0, c = 0),
  debug = FALSE)

estimate.items.3pl.bme(responses, fix = list(), iter = 30, conv = 0.01,
  prior = list(a.mu = 0, a.sig = 0.2, b.mu = 0, b.sig = 1, c.alpha = 5, c.beta
  = 43), bound = list(a = 2, b = 3.5, c = 0.25), init = list(a = 1, b = 0, c
  = 0.1), debug = FALSE)
}
\arguments{
\item{responses}{a data frame of responses}

\item{model}{the IRT model}

\item{method}{the estimation method}

\item{...}{further arguments}

\item{people}{a data frame of people parameters}

\item{fix}{a list of fixed item parameters}

\item{iter}{the maximum iterations}

\item{conv}{the convergence criterion}

\item{bound}{the bounds of item parameters}

\item{init}{a list of initial item parameters}

\item{debug}{\code{TRUE} to turn on debug mode}

\item{prior}{a list of parameters for a-, b-, c-parameter prior distributions}
}
\value{
a data frame of estimated item parameters

estimated item parameters and diagnosis data if debug mode is on
}
\description{
\code{estimate.items} is a wrapper function for estimating item parameters

\code{estimate.items.3pl.jmle} calibrates item parameters with knwon thetas using joint maximum likelihood.

\code{estimate.items.3pl.mmle} calibrates item parameters without knowing people parameters using marginal maximum likelihood.

\code{estimate.items.3pl.bme} calibrates item parameters without knowing people parameters using bayesian maximum likelihood.
}
\details{
For the joint maximum likelihood estimation, refer to Baker and Kim (2004), pp. 46-54. \cr
To fixing item parameters, pass in a number or a vector (the same length with the items) to the \code{fix} argument.\cr
The debug mode prints convergence process and add \code{diagnosis} data to output

For the marginal maximum likelihood estimation, refer to Baker and Kim (2004), pp.166-174.

For the Bayesian maximum likelihood estimation, refer to Baker and Kim (2004), pp.183-191.
In \code{estimate.items.3pl.bme}, a parameters is assumed to have a lognormal prior distribution, 
b parameters a normal prior distribution, and c parameters a beta prior distribution.
}
\examples{
\dontrun{
# data generation
data <- irt.model(model="3pl")$gen.data(2000, 50)
# JMLE
x <- estimate.items(data$responses, model="3pl", method="jmle", people=data$people, debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
# MMLE
x <- estimate.items(data$responses, model="3pl", method="mmle", debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
# BME
x <- estimate.items(data$responses, model="3pl", method="bme", debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
}
\dontrun{
# data generation
data <- irt.model(model="3pl")$gen.data(2000, 50)
# JMLE
x <- estimate.items.3pl.jmle(data$responses, data$people, debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
# MMLE
x <- estimate.items.3pl.mmle(data$responses, debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
# BME
x <- estimate.items.3pl.bme(data$responses, debug=TRUE)
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0, 2), ylim=c(0, 2), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$b, x$items$b, xlim=c(-4, 4), ylim=c(-4, 4), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
plot(data$items$c, x$items$c, xlim=c(0, .3), ylim=c(0, .3), pch=16, 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.6))
}
}

