% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimation.R
\name{estimate_3pl}
\alias{estimate_3pl}
\title{Estimate Both People and Item Parameters}
\usage{
estimate_3pl(responses, ...)
}
\arguments{
\item{responses}{a data frame of responses}

\item{...}{other optional arguments}
}
\value{
a 3PL model with estimated people and item parameters
}
\description{
Estimates both people and item responses using MMLE and JMLE
}
\examples{
\dontrun{
data <- irt_model("3pl")$gendata(2000, 50)
x <- estimate_3pl(data$responses, debug=TRUE)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
cor(data$items, x$items)
plot(data$items$a, x$items$a, xlim=c(0,2), ylim=c(0,2), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
plot(data$items$b, x$items$b, xlim=c(-3,3), ylim=c(-3,3), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
plot(data$items$c, x$items$c, xlim=c(0,.4), ylim=c(0,.4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
}
}

