% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agplot.R
\name{print.ag}
\alias{print.ag}
\title{Print Automatic Labels and Units for ggplot}
\usage{
\method{print}{ag}(x, labeller = getOption("yamlet_labeller", default = as_lab), ...)
}
\arguments{
\item{x}{class 'ag' from \code{\link{agplot}}}

\item{labeller}{a function (or its name) like \code{\link{as_lab}} to generate axis labels}

\item{...}{passed arguments}
}
\value{
used for side effects
}
\description{
Prints automatic labels and units for ggplot.
Reworks the labels as a function of attributes
in corresponding data. Default for \code{labeller}
(\code{\link{as_lab}}) will
receive existing labels one at a time
and corresponding attributes (if any) from data.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
library(ggplot2)
library(dplyr)
library(magrittr)
# par(ask = FALSE)
options(enclose = c('[ ',' ]'))

# Filter() strips 'label' from factors (see legend), but not vectors:

file \%>\% decorate(coerce = TRUE) \%>\% filter(!is.na(conc)) \%>\%
agplot(aes(x = time, y = conc, color = Heart)) + geom_point()

# No factors created here, but print.ag promotes to factor if it can:

file \%>\% decorate \%>\% filter(!is.na(conc)) \%>\%
agplot(aes(x = time, y = conc, color = Heart)) + geom_point()

# Here we try a dataset with conditional labels and units.

file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')

# Note that there are two elements each for value label and value guide.
#'
file \%>\% decorate \%>\% as_yamlet
# Guide might have been mistaken for an attempt to provide codes/decodes
# for a factor.  However, the keys evaluate to logical on the data.frame.
# Seeing that, we test for one of them being all true, and if so we select it.

file \%>\% decorate \%>\% agplot(aes(x = time, y = value, color = event)) + geom_point()

# In the above example, we are plotting doses and concentrations, which have
# different labels and units, so we can't improve on the y axis label.
# But if we subset to just one of these, then only one of the named conditions
# will be always true (and will therefore be promoted).

file \%>\% decorate \%>\%
filter(event == 'conc') \%>\%
agplot(aes(x = time, y = value, color = ApgarInd)) + geom_point()

file \%>\% decorate \%>\%
filter(event == 'dose') \%>\%
agplot(aes(x = time, y = value, color = Wt)) +
geom_point() +
scale_y_log10() +
scale_color_gradientn(colours = rainbow(4))

}
\seealso{
Other lab: 
\code{\link{agplot}()},
\code{\link{as_lab.list}()},
\code{\link{as_lab}()},
\code{\link{singularity}()}
}
\concept{lab}
