% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-poisson_log_loss.R
\name{poisson_log_loss}
\alias{poisson_log_loss}
\alias{poisson_log_loss.data.frame}
\alias{poisson_log_loss_vec}
\title{Mean log loss for Poisson data}
\usage{
poisson_log_loss(data, ...)

\method{poisson_log_loss}{data.frame}(data, truth, estimate, na_rm = TRUE, ...)

poisson_log_loss_vec(truth, estimate, na_rm = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true counts
(that is \code{integer}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:nse-force]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, an \code{integer} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{poisson_log_loss_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the loss function for the Poisson distribution.
}
\examples{
count_truth <- c(2L,   7L,   1L,   1L,   0L,  3L)
count_pred  <- c(2.14, 5.35, 1.65, 1.56, 1.3, 2.71)
count_results <- dplyr::tibble(count = count_truth, pred = count_pred)

# Supply truth and predictions as bare column names
poisson_log_loss(count_results, count, pred)

}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq_trad}()},
\code{\link{rsq}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
Max Kuhn
}
\concept{accuracy metrics}
\concept{numeric metrics}
