% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_function.R
\name{apa}
\alias{apa}
\title{apa}
\usage{
apa(test.object, tails = 2, sig.digits = 2, p.lb = 0.01)
}
\arguments{
\item{test.object}{A hypothesis test object generated by functions such as t.test(), cor.test, chisq.test()}

\item{tails}{The number of tails in the test (1 or 2)}

\item{sig.digits}{The number of digits results are rounded to}

\item{p.lb}{The lower bound of the p-value display. If the p-value is less than p.lb, the exact value will not be displayed.}
}
\description{
This function takes a hypothesis test object (e.g.; t.test(), cor.test(), chisq.test()) as an input, and returns a string with the test result in APA format.
}
\examples{

x <- rnorm(100)
y <- x + rnorm(100)
a <- sample(1:3, size = 200, prob = c(.3, .2, .5), replace = TRUE)
b <- sample(1:3, size = 200, prob = c(.3, .2, .5), replace = TRUE)

apa(t.test(x, y))
apa(cor.test(x, y))
apa(chisq.test(table(a, b)))



}
\keyword{apa}
