% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{p}
\alias{p}
\alias{p0}
\alias{pc}
\alias{pcs}
\alias{pcc}
\alias{pcnl}
\alias{pcsc}
\alias{pc_and}
\title{paste variants}
\usage{
p(...)

p0(...)

pc(..., sep = "")

pcs(..., sep = "")

pcc(..., sep = "")

pcnl(..., sep = "")

pcsc(..., sep = "")

pc_and(..., sep = "")
}
\arguments{
\item{..., sep}{passed on to \code{\link[base:paste]{base::paste}}}
}
\description{
Wrappers around \code{\link[base:paste]{base::paste}} with a variety of defaults:
\tabular{llcc}{
   \code{}         \tab \strong{mnemonic}         \tab \strong{\code{collapse=}} \tab \strong{\code{sep=}} \cr
   \code{p()}      \tab paste                     \tab \code{NULL}               \tab \code{" "}   \cr
   \code{p0()}     \tab paste0                    \tab \code{NULL}               \tab \code{""}    \cr
   \code{pc()}     \tab paste collapse            \tab \code{""}                 \tab \code{""}    \cr
   \code{pcs()}    \tab paste collapse space      \tab \code{" "}                \tab \code{""}    \cr
   \code{pcc()}    \tab paste collapse comma      \tab \code{", "}               \tab \code{""}    \cr
   \code{pcsc()}   \tab paste collapse semicolon  \tab \code{"; "}               \tab \code{""}    \cr
   \code{pcnl()}   \tab paste collapse newline    \tab \code{"\n"}               \tab \code{""}    \cr
   \code{pc_and()} \tab paste collapse and        \tab \emph{varies}             \tab \code{""}    \cr
}
}
\examples{
x <- head(letters, 3)
y <- tail(letters, 3)
# paste
p(x, y)
p0(x, y)
# paste + collapse
pc(x)
pc(x, y)
pcs(x)
pcc(x)
pcc(x, y)
pcsc(x)
pcnl(x)
pc_and(x[1:2])
pc_and(x[1:3])
pc_and(x, y)
pc_and(x, y, sep = "-")
pc_and(x[1])
pc_and(x[0])
}
\seealso{
\code{\link{wrap}} \code{\link{sentence}}
}
