% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearn.R
\name{FindClosestPackage}
\alias{FindClosestPackage}
\title{Find closest matching package}
\usage{
FindClosestPackage(pkg, maxdist = 2, auto.select = TRUE,
  username.pref = c("cran", "ropensci", "rstudio", "tidyverse", "hadley",
  "yihui", "RcppCore", "eddelbuettel", "ropenscilabs", "hrbrmstr", "thej022214",
  "bomeara"))
}
\arguments{
\item{pkg}{A single package}

\item{maxdist}{The maximum distance that counts as a match}

\item{auto.select}{If TRUE, make a best guess in case of multiple equally good}

\item{username.pref}{In case of matches, user names in order of preference.}
}
\value{
pkgs that match the constraints
}
\description{
Find closest matching package
}
\details{
Inspired by githubinstall::gh_suggest() but allows being pickier about match. The username.pref is based on my guesses on priority: "cran" is a mirror for packages that have been on CRAN at some point, but could have been taken off; "ropensci" and "rstudio" produce really useful packages, etc.
}
\examples{
\dontrun{
yearn(TreEvo) # A package on github, not CRAN (yet)
}

}
