% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-part.R, R/extendr-wrappers.R
\name{date_part}
\alias{date_part}
\alias{year}
\alias{month}
\alias{quarter}
\alias{isoweek}
\alias{isowday}
\alias{wday}
\alias{mday}
\alias{yday}
\title{Fast Date Part Extracting}
\usage{
year(ref_date)

month(ref_date)

quarter(ref_date)

isoweek(ref_date)

isowday(ref_date)

wday(ref_date)

mday(ref_date)

yday(ref_date)
}
\arguments{
\item{ref_date, }{a Date vector. It will try to convert the input to date via \code{\link[=ymd]{ymd()}},
if the input is not a Date.}
}
\value{
an integer vector
}
\description{
These date helper functions provide the similar functionalities like in \code{data.table} or
\code{lubridate} package. They are implemented by the Rust Lang's standard library and very
fast.
}
\details{
\itemize{
\item year, month, quarter: get the year, month, quarter part
\item yday: the day of year
\item mday: the day of month
\item wday: the day of the week (Sunday is 1)
\item isoweek: ISO 8601 week
\item isowday: the day of week (ISO 8601 weekday number, Monday is 1)
}
}
\examples{
year(210205)
month(210205)
quarter(210205)
yday(210205)
mday(210205)
wday(210117)
isowday(210117)
isoweek(210101)

}
\references{
ISO week day, https://en.wikipedia.org/wiki/ISO_week_date
ISO 8601, https://en.wikipedia.org/wiki/ISO_8601
}
