% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ypr_plot_yield.ypr_populations}
\alias{ypr_plot_yield.ypr_populations}
\title{Plot Yield by Exploitation/Capture Probability}
\usage{
\method{ypr_plot_yield}{ypr_populations}(
  object,
  y = "Yield",
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE,
  u = harvest,
  plot_values = TRUE,
  ...
)
}
\arguments{
\item{object}{The populations or populations.}

\item{y}{A string of the term on the y-axis.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of the biomass versus number of individuals.}

\item{u}{A flag specifying whether to plot the exploitation rate as opposed to the capture rate.}

\item{plot_values}{A flag specifying whether to plot the actual and optimal values.}

\item{...}{Unused parameters.}
}
\value{
A ggplot2 object.
}
\description{
Plots the 'Yield', 'Age', 'Length', 'Weight', 'Effort', or 'YPUE'
by the annual interval exploitation/capture probability.
}
\examples{
\dontrun{
ypr_plot_yield(ypr_populations(Rk = c(2.5, 4.6), Llo = c(0, 60)), plot_values = FALSE) +
  ggplot2::facet_wrap(~Llo) +
  ggplot2::aes_string(group = "Rk", color = "Rk") +
  ggplot2::scale_color_manual(values = c("black", "blue"))

ypr_plot_yield(ypr_populations(Rk = c(2.5, 4.6), Llo = c(0, 60))) +
  ggplot2::facet_grid(Rk ~ Llo)
}
}
\seealso{
\code{\link[=ypr_populations]{ypr_populations()}} and \code{\link[=ypr_yields]{ypr_yields()}}
}
