% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Returns all available zendesk users.}
\usage{
get_users(email_id, token, subdomain)
}
\arguments{
\item{email_id}{Zendesk Email Id (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}
}
\value{
Data Frame with user details
}
\description{
It takes your Email Id, authentication token,
sub-domain and parse all the users in a list.
It iterates through all the pages returning only 100 users per
page until the "next_page" parameter becomes null indicating
there are no more pages to fetch.
}
\details{
It's not a good practice to write down these authentication
parameters in your code. There are various methods and
packages available that are more secure; this package
doesn't require you to use any one in particular.
}
\examples{
\dontrun{
users <- get_users(email_id, token, subdomain)
}
}
\references{
\url{https://developer.zendesk.com/rest_api
/docs/support/users}
}
