% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Find peaks in a periodogram}
\usage{
find_peaks(data, n_peaks = 3)
}
\arguments{
\item{data}{\link[behavr:behavr]{behavr::behavr} table representing a periodogram, as returned by \link{periodogram}}

\item{n_peaks}{maximal numbers of peak to be detected}
}
\value{
\link[behavr:behavr]{behavr::behavr} table that is \code{data} with an extra column \code{peak}.
\code{peak} is filled with zeros except for rows match a peak.
In which case, rows have an integer value corresponding to the rank of the peak (e.g. 1 for the first peak).
}
\description{
This function locates the peaks in a pregenerated periodogram.
Detection is based on \link[pracma:findpeaks]{pracma::findpeaks}.
Only the significant (i.e. \code{power > signif_threshold}) peaks are extracted.
}
\examples{
data(dams_sample)
# only four ndividuals for the sake of the example
dt <- dams_sample[xmv(region_id) \%in\% c(1, 7, 21, 31)]
per_dt_xs <- periodogram(activity, dt, FUN = chi_sq_periodogram)
per_dt_xs_with_peaks <- find_peaks(per_dt_xs)
per_dt_xs_with_peaks[peak == 1]
}
\references{
\itemize{
\item \href{https://rethomics.github.io/zeitgebr.html}{zeitgebr tutorial} -- the relevant rehtomics tutorial
}
}
\seealso{
\itemize{
\item \link{periodogram} -- to generate a periodogram in a first place
\item \link[ggetho:geom_peak]{ggetho::geom_peak} -- a layer to show peaks on a periodogram
}
}
