% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{convert_occupancy}
\alias{convert_occupancy}
\title{Converting an Occupancy Matrix}
\usage{
convert_occupancy(x, to = c("", "<", ">", "v", "^"))
}
\arguments{
\item{x}{an occupancy \code{\link{matrix}} consisting of the
\code{\link{character}} \code{""} (unoccupied), \code{"l"} (left),
\code{"r"} (right), \code{"d"} (down) or \code{"u"} (up) as returned by
\code{\link{zenplot}()}.}

\item{to}{a \code{\link{vector}} of symbols to which \code{""}, 
\code{"l"}, \code{"r"}, \code{"d"} and \code{"u"}
should be mapped.}
}
\value{
\code{\link{matrix}} as the occupancy matrix but with entries replaced
       by those in \code{to}.
}
\description{
Convert an occupancy matrix to matrix with different symbols.
}
\examples{
## Generate some data
n <- 1000 # sample size
d <- 20 # dimension
set.seed(271) # set seed (for reproducibility)
x <- matrix(rnorm(n * d), ncol = d) # i.i.d. N(0,1) data

## Extract the occupancy matrix from a zenplot
res <- zenplot(x)
(occ <- res[["path"]][["occupancy"]])

## Convert the occupancy matrix
convert_occupancy(occ)
}
\seealso{
Other zenplot technical tools: \code{\link{is.standard}},
  \code{\link{n2dcols_aux}}, \code{\link{num_cols}},
  \code{\link{turn_checker}}
}
\author{
Marius Hofert
}
\concept{zenplot technical tools}
\keyword{utilities}
