% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.sam.sensitivity}
\alias{Zeta.sam.sensitivity}
\title{Sensitivity analysis for the sample size of zeta}
\usage{
Zeta.sam.sensitivity(data.spec, order = 1, sam.min = 500, sam.max = 2000,
  sam.incr = 500, reps = 20, display = TRUE, plot = TRUE,
  notch = TRUE)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam.min}{Minimum number of samples for which the zeta-diversity is computed.}

\item{sam.max}{Maximum number of samples for which the zeta-diversity is computed.}

\item{sam.incr}{Increment of the number of samples for which the zeta-diversity is computed. It also serves as the initial number.}

\item{reps}{Number of replicates of zeta-diversity computations for each sample size}

\item{display}{Boolean value (TRUE or FALSE) indicating if the current value of the sample size must be displayed. Acts as a counter.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted as a boxplot of the zeta-diversity distributions for each sample size}

\item{notch}{Boolean value (TRUE or FALSE) indicating if the notches must be plotted in the boxplot.}
}
\value{
\code{Zeta.sam.sensitivity} returns a matrix with \code{(sam.max-sam.min)/sam.incr} columns and \code{reps} rows.
}
\description{
Computes zeta diversity for a given order (number of assemblages or sites) for a range of sample sizes, to assess the sensitivity to this parameter.
}
\details{
Note that the execution of \code{Zeta.sam.sensitivity} can be quite lengthy, because of the number of replicates needed.
}
\examples{
\donttest{
#Note that the sensitivity analyses in the following two examples are quite long to run,
#typically around 10 minutes for the first example and 1-2 minutes for the second.

data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]

dev.new()
zeta.sens <- Zeta.sam.sensitivity(data.spec, order = 3, sam.min = 250, sam.max = 1000,
    sam.incr = 250, reps = 20, display = TRUE, plot = TRUE, notch = TRUE)
zeta.sens

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]

dev.new()
zeta.sens.species <- Zeta.sam.sensitivity(data.species, order = 3, sam.min = 250, sam.max = 1000,
    sam.incr = 250, reps = 20, plot = TRUE, notch = TRUE)
zeta.sens.species
}
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}
}

