% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{glm.cons}
\alias{glm.cons}
\title{Fitting Generalized Linear Models with constraint on the coefficients signs}
\usage{
glm.cons(formula, family = stats::gaussian(), data, weights, subset,
  na.action, start = NULL, etastart, mustart, offset, control = list(...),
  model = TRUE, method = "glm.fit.cons", cons = -1, cons.inter = 1,
  x = FALSE, y = TRUE, contrasts = NULL, ...)
}
\arguments{
\item{formula}{as for \code{\link{glm}}}

\item{family}{as for \code{\link{glm}}}

\item{data}{as for \code{\link{glm}}}

\item{weights}{as for \code{\link{glm}}}

\item{subset}{as for \code{\link{glm}}}

\item{na.action}{as for \code{\link{glm}}}

\item{start}{as for \code{\link{glm}}}

\item{etastart}{as for \code{\link{glm}}}

\item{mustart}{as for \code{\link{glm}}}

\item{offset}{as for \code{\link{glm}}}

\item{control}{as for \code{\link{glm}}}

\item{model}{as for \code{\link{glm}}}

\item{method}{the method used in fitting the model. The default method "\code{glm.fit.cons}" uses function {nnnpls} from package nnls instead of \code{lm.fit} to impose the sign of the coefficients. As in \code{glm}, the alternative method "\code{model.frame}" returns the model frame and does no fitting.}

\item{cons}{type of constraint. Default is -1 for negative coefficients on the predictors. The other option is 1 for positive coefficients on the predictors.}

\item{cons.inter}{type of constraint for the intercept. Default is 1 for positive intercept, suitable for Gaussian family. The other option is -1 for negative intercept, suitable for binomial family.}

\item{x}{as for \code{\link{glm}}}

\item{y}{as for \code{\link{glm}}}

\item{contrasts}{as for \code{\link{glm}}}

\item{...}{as for \code{\link{glm}}}
}
\value{
The value returned by \code{glm.cons} has exactly the same structure as the value returned by \code{glm} and \code{glm.2}.
}
\description{
\code{glm.cons} is an adaptation of function \code{glm2} from package \{glm2\} in which the least squares estimation is replaced by a regression with signs constraint on the coefficients using function \code{nnnpls} from package \{nnls\}.
}
\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm.cons(counts ~ outcome + treatment, family = poisson())
glm.D93.ngl <- glm.cons(counts ~ outcome + treatment, family = poisson(),
   method="glm.fit.cons")
summary(glm.D93)
summary(glm.D93.ngl)
}
\references{
Marschner, I.C. (2011) glm2: Fitting generalized linear models with convergence problems. \emph{The R Journal}, 3(2), 12-15.
}
\seealso{
\code{\link{glm}}, \code{\link{glm2}}
}

