% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpeMean.R
\name{zipfpeMean}
\alias{zipfpeMean}
\title{Expected value of the Zipf-PE distribution.}
\usage{
zipfpeMean(alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 2}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{tolerance}{Tolerance used in the calculations (default = \eqn{10^{-4}}).}
}
\value{
A positive real value corresponding to the mean value of the Zipf-PE distribution.
}
\description{
Computes the expected value of the Zipf-PE distribution for given values of parameters
\eqn{\alpha} and \eqn{\beta}.
}
\details{
The mean of the distribution only exists for \eqn{\alpha} strictly greater than 2.
It is computed by calculating the partial sums of the serie, and stopping when two
consecutive partial sums differ less than the \code{tolerance} value.
The value of the last partial sum is returned.
}
\examples{
zipfpeMean(2.5, 1.3)
zipfpeMean(2.5, 1.3, 10^(-3))
}
