% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_learn.R
\name{dist_learn}
\alias{dist_learn}
\title{Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1. Assume that
the intercepts are different among subjects, a distributed learning algorithm
is used to compute the common coefficients of thecovariates for the 
state-dependent log Poisson means and the logit structural zero proportion.}
\usage{
dist_learn(ylist, xlist, timelist, prior_init, tpm_init, emit_init, zero_init,
  yceil = NULL, rho = 1, maxit = 100, tol = 1e-04, print = TRUE)
}
\arguments{
\item{ylist}{list of observed time series values for each subject}

\item{xlist}{list of design matrices for each subject.}

\item{timelist}{list of time indices}

\item{prior_init}{a vector of initial values for prior probability for each state}

\item{tpm_init}{a matrix of initial values for transition rate matrix}

\item{emit_init}{a vector of initial values for the means for each poisson distribution}

\item{zero_init}{a scalar initial value for the structural zero proportion}

\item{yceil}{a scalar defining the ceiling of y, above which the values will be
truncated. Default to NULL.}

\item{rho}{tuning parameters in the distributed learning algorithm.}

\item{maxit}{maximum number iteration. Default to 100.}

\item{tol}{tolerance in the terms of the relative change in the norm of the
common coefficients. Default to 1e-4.}

\item{print}{whether to print each iteration. Default to TRUE.}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1. Assume that
the intercepts are different among subjects, a distributed learning algorithm
is used to compute the common coefficients of thecovariates for the 
state-dependent log Poisson means and the logit structural zero proportion.
}
\examples{
\dontrun{
set.seed(930518)
ylist <- vector(mode="list",length=20)
xlist <- vector(mode="list",length=20)
timelist <- vector(mode="list",length=20)
for(n in 1:20){
 priorparm <- 0 + runif(1,-0.1,0.1)
 tpmparm <- c(-1+ runif(1,-0.1,0.1),-2+ runif(1,-0.2,0.2))
 zeroindex <- c(1,0)
 zeroparm <- c(0+ runif(1,-0.1,0.1),-1,1)
 emitparm <- c(2+ runif(1,-0.1,0.1),0.5,-0.5,
               3+ runif(1,-0.1,0.1),0.3,-0.2)
 workparm <- c(priorparm,tpmparm,zeroparm,emitparm)
 timeindex <- rep(1,1440)
 for(i in 2:1440) timeindex[i] <- timeindex[i-1] + sample(1:4,1)
 timelist[[n]] <- timeindex
 
 xlist[[n]] <- matrix(rnorm(2880),nrow=1440,ncol=2)
 
 result <- hmmsim2.cont(workparm,2,1440,zeroindex,emit_x=xlist[[n]],
                        zeroinfl_x=xlist[[n]],timeindex=timeindex)
 ylist[[n]] <- result$series
}

prior_init=c(0.5,0.5)
tpm_init=matrix(c(-0.2,0.2,0.1,-0.1),2,2,byrow=TRUE)
zero_init=0.4
emit_init=c(7,21)

result <- dist_learn(ylist, xlist, timelist, prior_init, tpm_init, 
                    emit_init, zero_init, rho=1, 
                    maxit=20, tol=1e-4, print=TRUE)

}
}
\references{
Liu, Yu-Ying, et al. "Efficient learning of continuous-time hidden 
markov models for disease progression." Advances in neural information 
processing systems. 2015.
}
