







macro_rules! cfg_if {

    ($(
        if #[cfg($($meta:meta),*)] { $($it:item)* }
    ) else * else {
        $($it2:item)*
    }) => {
        cfg_if! {
            @__items
            () ;
            $( ( ($($meta),*) ($($it)*) ), )*
            ( () ($($it2)*) ),
        }
    };


    (
        if #[cfg($($i_met:meta),*)] { $($i_it:item)* }
        $(
            else if #[cfg($($e_met:meta),*)] { $($e_it:item)* }
        )*
    ) => {
        cfg_if! {
            @__items
            () ;
            ( ($($i_met),*) ($($i_it)*) ),
            $( ( ($($e_met),*) ($($e_it)*) ), )*
            ( () () ),
        }
    };





    (@__items ($($not:meta,)*) ; ) => {};
    (@__items ($($not:meta,)*) ; ( ($($m:meta),*) ($($it:item)*) ),
     $($rest:tt)*) => {



        cfg_if! { @__apply cfg(all($($m,)* not(any($($not),*)))), $($it)* }




        cfg_if! { @__items ($($not,)* $($m,)*) ; $($rest)* }
    };


    (@__apply $m:meta, $($it:item)*) => {
        $(#[$m] $it)*
    };
}

macro_rules! s {
    ($($(#[$attr:meta])* pub $t:ident $i:ident { $($field:tt)* })*) => ($(
        s!(it: $(#[$attr])* pub $t $i { $($field)* });
    )*);
    (it: $(#[$attr:meta])* pub union $i:ident { $($field:tt)* }) => (
        compile_error!("unions cannot derive extra traits, use s_no_extra_traits instead");
    );
    (it: $(#[$attr:meta])* pub struct $i:ident { $($field:tt)* }) => (
        __item! {
            #[repr(C)]
            #[cfg_attr(feature = "extra_traits", derive(Debug, Eq, Hash, PartialEq))]
            #[allow(deprecated)]
            $(#[$attr])*
            pub struct $i { $($field)* }
        }
        #[allow(deprecated)]
        impl ::Copy for $i {}
        #[allow(deprecated)]
        impl ::Clone for $i {
            fn clone(&self) -> $i { *self }
        }
    );
}

macro_rules! s_no_extra_traits {
    ($($(#[$attr:meta])* pub $t:ident $i:ident { $($field:tt)* })*) => ($(
        s_no_extra_traits!(it: $(#[$attr])* pub $t $i { $($field)* });
    )*);
    (it: $(#[$attr:meta])* pub union $i:ident { $($field:tt)* }) => (
        cfg_if! {
            if #[cfg(libc_union)] {
                __item! {
                    #[repr(C)]
                    $(#[$attr])*
                    pub union $i { $($field)* }
                }

                impl ::Copy for $i {}
                impl ::Clone for $i {
                    fn clone(&self) -> $i { *self }
                }
            }
        }
    );
    (it: $(#[$attr:meta])* pub struct $i:ident { $($field:tt)* }) => (
        __item! {
            #[repr(C)]
            $(#[$attr])*
            pub struct $i { $($field)* }
        }
        #[allow(deprecated)]
        impl ::Copy for $i {}
        #[allow(deprecated)]
        impl ::Clone for $i {
            fn clone(&self) -> $i { *self }
        }
    );
}

macro_rules! missing {
    ($($(#[$attr:meta])* pub enum $i:ident {})*) => ($(
        $(#[$attr])* #[allow(missing_copy_implementations)] pub enum $i { }
    )*);
}

macro_rules! e {
    ($($(#[$attr:meta])* pub enum $i:ident { $($field:tt)* })*) => ($(
        __item! {
            #[cfg_attr(feature = "extra_traits", derive(Debug, Eq, Hash, PartialEq))]
            $(#[$attr])*
            pub enum $i { $($field)* }
        }
        impl ::Copy for $i {}
        impl ::Clone for $i {
            fn clone(&self) -> $i { *self }
        }
    )*);
}

macro_rules! s_paren {
    ($($(#[$attr:meta])* pub struct $i:ident ( $($field:tt)* ); )* ) => ($(
        __item! {
            #[cfg_attr(feature = "extra_traits", derive(Debug, Eq, Hash, PartialEq))]
            $(#[$attr])*
            pub struct $i ( $($field)* );
        }
        impl ::Copy for $i {}
        impl ::Clone for $i {
            fn clone(&self) -> $i { *self }
        }
    )*);
}




























cfg_if! {
    if #[cfg(libc_const_extern_fn)] {
        macro_rules! f {
            ($($(#[$attr:meta])* pub $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                pub $($constness)* unsafe extern fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }

        macro_rules! safe_f {
            ($($(#[$attr:meta])* pub $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                pub $($constness)* extern fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }

        macro_rules! const_fn {
            ($($(#[$attr:meta])* $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                $($constness)* fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }

    } else {
        macro_rules! f {
            ($($(#[$attr:meta])* pub $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                pub unsafe extern fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }

        macro_rules! safe_f {
            ($($(#[$attr:meta])* pub $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                pub extern fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }

        macro_rules! const_fn {
            ($($(#[$attr:meta])* $({$constness:ident})* fn $i:ident(
                        $($arg:ident: $argty:ty),*
            ) -> $ret:ty {
                $($body:stmt);*
            })*) => ($(
                #[inline]
                $(#[$attr])*
                fn $i($($arg: $argty),*
                ) -> $ret {
                    $($body);*
                }
            )*)
        }
    }
}

macro_rules! __item {
    ($i:item) => {
        $i
    };
}

macro_rules! align_const {
    ($($(#[$attr:meta])*
       pub const $name:ident : $t1:ty
       = $t2:ident { $($field:tt)* };)*) => ($(
        #[cfg(libc_align)]
        $(#[$attr])*
        pub const $name : $t1 = $t2 {
            $($field)*
        };
        #[cfg(not(libc_align))]
        $(#[$attr])*
        pub const $name : $t1 = $t2 {
            $($field)*
            __align: [],
        };
    )*)
}


macro_rules! deprecated_mach {
    (pub const $id:ident: $ty:ty = $expr:expr;) => {
        #[deprecated(
            since = "0.2.55",
            note = "Use the `mach2` crate instead",
        )]
        #[allow(deprecated)]
        pub const $id: $ty = $expr;
    };
    ($(pub const $id:ident: $ty:ty = $expr:expr;)*) => {
        $(
            deprecated_mach!(
                pub const $id: $ty = $expr;
            );
        )*
    };
    (pub type $id:ident = $ty:ty;) => {
        #[deprecated(
            since = "0.2.55",
            note = "Use the `mach2` crate instead",
        )]
        #[allow(deprecated)]
        pub type $id = $ty;
    };
    ($(pub type $id:ident = $ty:ty;)*) => {
        $(
            deprecated_mach!(
                pub type $id = $ty;
            );
        )*
    }
}

#[cfg(not(libc_ptr_addr_of))]
macro_rules! ptr_addr_of {
    ($place:expr) => {
        &$place
    };
}

#[cfg(libc_ptr_addr_of)]
macro_rules! ptr_addr_of {
    ($place:expr) => {
        ::core::ptr::addr_of!($place)
    };
}
