

/*
Adapted from https://github.com/rust-embedded/msp430.

See also src/imp/msp430.rs.

Refs:
- MSP430x5xx and MSP430x6xx Family User's Guide, Rev. Q
  https://www.ti.com/lit/ug/slau208q/slau208q.pdf

Generated asm:
- msp430 https://godbolt.org/z/fc6h89xac
*/

#[cfg(not(portable_atomic_no_asm))]
use core::arch::asm;

pub(super) use super::super::msp430 as atomic;

pub(super) type State = u16;


#[inline(always)]
pub(super) fn disable() -> State {
    let sr: State;


    unsafe {



        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "mov r2, {sr}", // sr = SR
            "dint {{ nop",  // SR.GIE = 0
            sr = out(reg) sr,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        {
            llvm_asm!("mov r2, $0" : "=r"(sr) ::: "volatile");
            llvm_asm!("dint { nop" ::: "memory" : "volatile");
        }
    }
    sr
}






#[inline(always)]
pub(super) unsafe fn restore(prev_sr: State) {

    unsafe {










        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "nop {{ mov {prev_sr}, r2 {{ nop", // SR = prev_sr
            prev_sr = in(reg) prev_sr,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        llvm_asm!("nop { mov $0, r2 { nop" :: "r"(prev_sr) : "memory" : "volatile");
    }
}
