use super::plumbing::*;
use super::*;











































































#[derive(Debug, Clone)]
pub struct MultiZip<T> {
    tuple: T,
}











macro_rules! reduce {
    ($a:expr, $b:expr, $c:expr, $d:expr, $( $x:expr ),+ => $fn:path) => {
        reduce!(reduce!($a, $b, $c, $d => $fn),
                reduce!($( $x ),+ => $fn)
                => $fn)
    };
    ($a:expr, $b:expr, $( $x:expr ),+ => $fn:path) => {
        reduce!(reduce!($a, $b => $fn),
                reduce!($( $x ),+ => $fn)
                => $fn)
    };
    ($a:expr, $b:expr => $fn:path) => { $fn($a, $b) };
    ($a:expr => $fn:path) => { $a };
}

macro_rules! nest {
    ($A:tt, $B:tt, $C:tt, $D:tt, $( $X:tt ),+) => {
        (nest!($A, $B, $C, $D), nest!($( $X ),+))
    };
    ($A:tt, $B:tt, $( $X:tt ),+) => {
        (($A, $B), nest!($( $X ),+))
    };
    ($A:tt, $B:tt) => { ($A, $B) };
    ($A:tt) => { $A };
}

macro_rules! flatten {
    ($( $T:ident ),+) => {{
        #[allow(non_snake_case)]
        fn flatten<$( $T ),+>(nest!($( $T ),+) : nest!($( $T ),+)) -> ($( $T, )+) {
            ($( $T, )+)
        }
        flatten
    }};
}

macro_rules! multizip_impls {
    ($(
        $Tuple:ident {
            $(($idx:tt) -> $T:ident)+
        }
    )+) => {
        $(
            impl<$( $T, )+> IntoParallelIterator for ($( $T, )+)
            where
                $(
                    $T: IntoParallelIterator,
                    $T::Iter: IndexedParallelIterator,
                )+
            {
                type Item = ($( $T::Item, )+);
                type Iter = MultiZip<($( $T::Iter, )+)>;

                fn into_par_iter(self) -> Self::Iter {
                    MultiZip {
                        tuple: ( $( self.$idx.into_par_iter(), )+ ),
                    }
                }
            }

            impl<'a, $( $T, )+> IntoParallelIterator for &'a ($( $T, )+)
            where
                $(
                    $T: IntoParallelRefIterator<'a>,
                    $T::Iter: IndexedParallelIterator,
                )+
            {
                type Item = ($( $T::Item, )+);
                type Iter = MultiZip<($( $T::Iter, )+)>;

                fn into_par_iter(self) -> Self::Iter {
                    MultiZip {
                        tuple: ( $( self.$idx.par_iter(), )+ ),
                    }
                }
            }

            impl<'a, $( $T, )+> IntoParallelIterator for &'a mut ($( $T, )+)
            where
                $(
                    $T: IntoParallelRefMutIterator<'a>,
                    $T::Iter: IndexedParallelIterator,
                )+
            {
                type Item = ($( $T::Item, )+);
                type Iter = MultiZip<($( $T::Iter, )+)>;

                fn into_par_iter(self) -> Self::Iter {
                    MultiZip {
                        tuple: ( $( self.$idx.par_iter_mut(), )+ ),
                    }
                }
            }

            impl<$( $T, )+> ParallelIterator for MultiZip<($( $T, )+)>
            where
                $( $T: IndexedParallelIterator, )+
            {
                type Item = ($( $T::Item, )+);

                fn drive_unindexed<CONSUMER>(self, consumer: CONSUMER) -> CONSUMER::Result
                where
                    CONSUMER: UnindexedConsumer<Self::Item>,
                {
                    self.drive(consumer)
                }

                fn opt_len(&self) -> Option<usize> {
                    Some(self.len())
                }
            }

            impl<$( $T, )+> IndexedParallelIterator for MultiZip<($( $T, )+)>
            where
                $( $T: IndexedParallelIterator, )+
            {
                fn drive<CONSUMER>(self, consumer: CONSUMER) -> CONSUMER::Result
                where
                    CONSUMER: Consumer<Self::Item>,
                {
                    reduce!($( self.tuple.$idx ),+ => IndexedParallelIterator::zip)
                        .map(flatten!($( $T ),+))
                        .drive(consumer)
                }

                fn len(&self) -> usize {
                    reduce!($( self.tuple.$idx.len() ),+ => Ord::min)
                }

                fn with_producer<CB>(self, callback: CB) -> CB::Output
                where
                    CB: ProducerCallback<Self::Item>,
                {
                    reduce!($( self.tuple.$idx ),+ => IndexedParallelIterator::zip)
                        .map(flatten!($( $T ),+))
                        .with_producer(callback)
                }
            }
        )+
    }
}

multizip_impls! {
    Tuple1 {
        (0) -> A
    }
    Tuple2 {
        (0) -> A
        (1) -> B
    }
    Tuple3 {
        (0) -> A
        (1) -> B
        (2) -> C
    }
    Tuple4 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
    }
    Tuple5 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
    }
    Tuple6 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
    }
    Tuple7 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
    }
    Tuple8 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
        (7) -> H
    }
    Tuple9 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
        (7) -> H
        (8) -> I
    }
    Tuple10 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
        (7) -> H
        (8) -> I
        (9) -> J
    }
    Tuple11 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
        (7) -> H
        (8) -> I
        (9) -> J
        (10) -> K
    }
    Tuple12 {
        (0) -> A
        (1) -> B
        (2) -> C
        (3) -> D
        (4) -> E
        (5) -> F
        (6) -> G
        (7) -> H
        (8) -> I
        (9) -> J
        (10) -> K
        (11) -> L
    }
}
