% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SORD_original.R
\name{SORD_original}
\alias{SORD_original}
\title{Second Order Rotatable Designs with original levels}
\usage{
SORD_original(v, n0, min_L, max_L, randomization = FALSE, variance = FALSE)
}
\arguments{
\item{v}{Number of input factors,v(3<=v<=16)}

\item{n0}{Number of centre points,n0(>0)}

\item{min_L}{A vector of minimum levels of the factors}

\item{max_L}{A vector of maximum levels of the factors}

\item{randomization}{It is for generating the randomized layout of the design. It takes either TRUE or FALSE  and by default, it is set to FALSE}

\item{variance}{This is for generating the moment matrix and prediction variance of the design based on a second order model. It gives unique prediction variance along with its frequencies. It takes either TRUE or FALSE  and by default, it is set to FALSE}
}
\value{
Second-Order Rotatable Designs with original levels
}
\description{
This function generates second order rotatable designs  given in Das and Narasimham (1962) for a given number of input factors (3<=v<=16) with original levels along with coded levels of the factors. It gives the randomized layout of the design along with the moment  matrix and prediction variance. Here, all the factors are having 5-levels except for v=7, which gives a rotatable design with 3-levels for each factor.
}
\examples{

library(AsymmetricSORDs)
SORD_original(4,3,c(10,15,20,25),c(15,20,25,30),FALSE,FALSE)

}
\references{
1) M. N. Das and V. L. Narasimham (1962). "Construction of rotatable designs through balanced incomplete block designs".

2) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<DOI: 10.1080/03610926.2021.1944213> "Theoretical developments in response surface designs: an informative review and further thoughts".
}
