% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_cosmosdb_account}
\alias{get_cosmosdb_account}
\alias{list_cosmosdb_accounts}
\title{Get Azure Cosmos DB account}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{get_cosmosdb_account(name)
list_cosmosdb_accounts()
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the Cosmos DB account.
}
}

\section{Details}{

\code{get_cosmosdb_account} retrieves the details for an existing Azure Cosmos DB account. \code{list_cosmosdb_accounts} retrieves all the Cosmos DB accounts within the resource group.
}

\section{Value}{

For \code{get_cosmosdb_account}, an object of class \code{az_cosmosdb} representing the Cosmos DB account. For \code{list_cosmosdb_accounts}, a list of such objects.
}

\seealso{
\link{create_cosmosdb_account}, \link{delete_cosmosdb_account}

For the SQL API client framework: \link{cosmos_endpoint}, \link{cosmos_database}, \link{cosmos_container}, \link{query_documents}

For the table storage API: \link[AzureTableStor:table_endpoint]{AzureTableStor::table_endpoint}

For the MongoDB API: \link{cosmos_mongo_endpoint}, \link[mongolite:mongo]{mongolite::mongo}
}
