% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_entity.R
\name{insert_table_entity}
\alias{insert_table_entity}
\alias{table_entity}
\alias{update_table_entity}
\alias{delete_table_entity}
\alias{list_table_entities}
\alias{get_table_entity}
\alias{import_table_entities}
\title{Operations on table entities (rows)}
\usage{
insert_table_entity(table, entity)

update_table_entity(
  table,
  entity,
  row_key = NULL,
  partition_key = NULL,
  etag = NULL
)

delete_table_entity(table, row_key, partition_key, etag = NULL)

list_table_entities(table, filter = NULL, select = NULL, as_data_frame = TRUE)

get_table_entity(table, row_key, partition_key, select = NULL)

import_table_entities(
  table,
  data,
  row_key = NULL,
  partition_key = NULL,
  batch_status_handler = c("warn", "stop", "message", "pass"),
  ...
)
}
\arguments{
\item{table}{A table object, of class \code{storage_table}.}

\item{entity}{For \code{insert_table_entity} and \code{update_table_entity}, a named list giving the properties (columns) of the entity. See 'Details' below.}

\item{row_key, partition_key}{For \code{get_table_entity}, \code{update_table_entity} and \code{delete_table_entity}, the row and partition key values that identify the entity to get, update or delete. For \code{import_table_entities}, the columns in the imported data to treat as the row and partition keys. The default is to use columns named 'RowKey' and 'PartitionKey' respectively.}

\item{etag}{For \code{update_table_entity} and \code{delete_table_entity}, an optional Etag value. If this is supplied, the update or delete operation will proceed only if the target entity's Etag matches this value. This ensures that an entity is only updated/deleted if it has not been modified since it was last retrieved.}

\item{filter, select}{For \code{list_table_entities}, optional row filter and column select expressions to subset the result with. If omitted, \code{list_table_entities} will return all entities in the table.}

\item{as_data_frame}{For \code{list_table_entities}, whether to return the results as a data frame, rather than a list of table rows.}

\item{data}{For \code{import_table_entities}, a data frame. See 'Details' below.}

\item{batch_status_handler}{For \code{import_table_entities}, what to do if one or more of the batch operations fails. The default is to signal a warning and return a list of response objects, from which the details of the failure(s) can be determined. Set this to "pass" to ignore the failure.}

\item{...}{For \code{import_table_entities}, further named arguments passed to \code{do_batch_transaction}.}
}
\value{
\code{insert_table_entity} and \code{update_table_entity} return the Etag of the inserted/updated entity, invisibly.

\code{get_table_entity} returns a named list of properties for the given entity.

\code{list_table_entities} returns a data frame if \code{as_data_frame=TRUE}, and a list of entities (rows) otherwise.

\code{import_table_entities} invisibly returns a named list, with one component for each value of the \code{PartitionKey} column. Each component contains the results of the individual operations to insert each row into the table.
}
\description{
Operations on table entities (rows)
}
\details{
These functions operate on rows of a table, also known as \emph{entities}. \code{insert}, \code{get}, \code{update} and \code{delete_table_entity} operate on an individual row. \code{import_table_entities} bulk-inserts multiple rows of data into the table, using batch transactions. \code{list_table_entities} queries the table and returns multiple rows, subsetted on the \code{filter} and \code{select} arguments.

Table storage imposes the following requirements for properties (columns) of an entity:
\itemize{
\item There must be properties named \code{RowKey} and \code{PartitionKey}, which together form the entity's unique identifier. These properties must be of type character.
\item The property \code{Timestamp} cannot be used (strictly speaking, it is reserved by the system).
\item There can be at most 255 properties per entity, although different entities can have different properties.
\item Table properties must be atomic. In particular, they cannot be nested lists.
}

Note that table storage does \emph{not} require that all entities in a table must have the same properties.

For \code{insert_table_entity}, \code{update_table_entity} and \code{import_table_entities}, you can also specify JSON text representing the data to insert/update/import, instead of a list or data frame.

\code{list_table_entities(as_data_frame=TRUE)} for a large table may be slow. If this is a problem, and you know that all entities in the table have the same schema, try setting \code{as_data_frame=FALSE} and converting to a data frame manually.
}
\examples{
\dontrun{

endp <- table_endpoint("https://mycosmosdb.table.cosmos.azure.com:443", key="mykey")
tab <- create_storage_table(endp, "mytable")

insert_table_entity(tab, list(
    RowKey="row1",
    PartitionKey="partition1",
    firstname="Bill",
    lastname="Gates"
))

get_table_entity(tab, "row1", "partition1")

# specifying the entity as JSON text instead of a list
update_table_entity(tab,
'{
    "RowKey": "row1",
    "PartitionKey": "partition1",
    "firstname": "Bill",
    "lastname": "Gates"
}')

# we can import to the same table as above: table storage doesn't enforce a schema
import_table_entities(tab, mtcars,
    row_key=row.names(mtcars),
    partition_key=as.character(mtcars$cyl))

list_table_entities(tab)
list_table_entities(tab, filter="firstname eq 'Satya'")
list_table_entities(tab, filter="RowKey eq 'Toyota Corolla'")

delete_table_entity(tab, "row1", "partition1")

}
}
\seealso{
\link{storage_table}, \link{do_batch_transaction}

\href{https://docs.microsoft.com/en-us/rest/api/storageservices/understanding-the-table-service-data-model}{Understanding the table service data model}
}
