% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsg_config.R
\name{nsg_config}
\alias{nsg_config}
\alias{nsg_rule}
\title{Network security group configuration}
\usage{
nsg_config(rules = list(), ...)

nsg_rule(name, dest_port = "*", dest_addr = "*", dest_asgs = NULL,
  source_port = "*", source_addr = "*", source_asgs = NULL,
  access = "allow", direction = "inbound", protocol = "Tcp",
  priority = NULL)
}
\arguments{
\item{rules}{for \code{nsg_config}, a list of security rule objects, each obtained via a call to \code{nsg_rule}.}

\item{...}{Other named arguments that will be treated as resource properties.}

\item{name}{For \code{nsg_rule}, a name for the rule.}

\item{dest_port, dest_addr, dest_asgs}{For \code{nsg_rule}, the destination port, address range, and application security groups for a rule.}

\item{source_port, source_addr, source_asgs}{For \code{nsg_rule}, the source port, address range, and application security groups for a rule.}

\item{access}{For \code{nsg_rule}, the action to take: "allow" or "deny".}

\item{direction}{For \code{nsg_rule}, the direction of traffic: "inbound" or "outbound".}

\item{protocol}{For \code{nsg_rule}, the network protocol: either "Tcp" or "Udp".}

\item{priority}{For \code{nsg_rule}, the rule priority. If NULL, this will be set automatically by AzureVM.}
}
\description{
Network security group configuration
}
\examples{
nsg_config()
nsg_config(list(nsg_rule_allow_ssh))  # for Linux
nsg_config(list(nsg_rule_allow_rdp))  # for Windows
nsg_config(list(nsg_rule_allow_http, nsg_rule_allow_https))

# a custom rule
nsg_config(list(
    nsg_rule(
        name="whitelist",
        source_addr="114.198.100.0/24",
        access="allow",
        protocol="*"
    )
))
}
\seealso{
\link{create_vm}, \link{vm_config}, \link{vmss_config}, \link{nsg_rules} for some predefined security rules
}
