% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{sad}
\alias{sad}
\title{Species-abundance distribution (SAD).}
\usage{
sad(comm, tree, octaves = TRUE, scale = FALSE, raref = 0, runs = 100)
}
\arguments{
\item{comm}{Either a vector with the abundance per species, or a sites x species matrix.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{octaves}{a boolean indicating whether octaves should be calculated.}

\item{scale}{scale y-axis to sum 1.}

\item{raref}{An integer specifying the number of individuals for rarefaction (individual based).
If raref < 1 no rarefaction is made.
If raref = 1 rarefaction is made by the minimum abundance among all sites.
If raref > 1 rarefaction is made by the abundance indicated.
If not specified, default is 0.}

\item{runs}{Number of resampling runs for rarefaction. If not specified, default is 100.}
}
\value{
A vector or matrix with the different values per class per community.
}
\description{
Fits the SAD to community abundance data, also using trees and with possible rarefaction.
}
\details{
The Species Abundance Distribution describes the commonness and rarity in ecological systems. It was recently expanded to accomodate phylegenetic and functional differences between species (Matthews et al., in prep.). Classes defined as n = 1, 2-3, 4-7, 8-15, .... Rarefaction allows comparison of sites with different total abundances.
}
\examples{
comm1 <- c(20,1,3,100,30)
comm2 <- c(1,2,12,0,45)
comm <- rbind(comm1, comm2)
tree <- tree.build(gower(1:5))
sad(comm1)
sad(comm)
sad(comm, octaves = FALSE)
sad(comm, tree, scale = TRUE)
sad(comm, raref = 1)
}
\references{
Matthews et al. (in prep.) Phylogenetic and functional dimensions of the species abundance distribution.
}
