% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{tree.addTip}
\alias{tree.addTip}
\title{Add tips to a tree.}
\usage{
tree.addTip(tree, tip, newTip, len, minDist = 0)
}
\arguments{
\item{tree}{A phylo object.}

\item{tip}{Vector of names of all sister species of new taxon to add.}

\item{newTip}{A string with the name of taxon to add.}

\item{len}{A numeric with the length of edge to add.}

\item{minDist}{The minimum distance from the sister species to the new species.}
}
\value{
A phylo object.
}
\description{
Add tips (i.e., new taxa) to an existing tree using an edge of a given length.
}
\details{
If len is smaller than the length of edges connecting all sister species to the new species, the minDist will be applied to the tree at a point above the connecting edge.
}
\examples{
par(mfrow = c(1,3))
tree = sim.tree(5, 100)
tree$tip.label = c("Sp1", "Sp2", "Sp3", "Sp4", "Sp5")
plot(tree)
ape::edgelabels(round(tree$edge.length, 3))

newTree = tree.addTip(tree, c("Sp1"), "Sp6", 0.1)
plot(newTree)
ape::edgelabels(round(newTree$edge.length, 3))

newTree = tree.addTip(tree, c("Sp1", "Sp2"), "Sp7", 0.2, 0.01)
plot(newTree)
ape::edgelabels(round(newTree$edge.length, 3))
}
