% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour2.R
\name{contour2.bcea}
\alias{contour2.bcea}
\alias{contour2}
\title{Specialised CE-plane Contour Plot}
\usage{
\method{contour2}{bcea}(
  he,
  comparison = NULL,
  wtp = 25000,
  graph = options("bcea.graph"),
  pos = "topleft",
  ...
)

contour2(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{The comparison being plotted. Default to \code{NULL}
If \code{graph_type="ggplot2"} the default value will choose all the possible
comparisons. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)}).}

\item{wtp}{The selected value of the willingness-to-pay. Default is
\code{25000}.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}. This is set globally
upon loading \code{BCEA} and can be modified for instance by using
\code{options("bcea.graph"="gg")}, or \verb{options("bcea.graph="plotly")}. Partial
matching still applies (so \code{gg} or \code{pl} also work). Not all plotting
functions have a \code{"plotly"} implementation, yet -- see help for the specifics.}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{...}{Arguments to be passed to \code{\link[=ceplane.plot]{ceplane.plot()}}. See the
relative manual page for more details.}
}
\value{
\item{contour}{ A ggplot item containing the requested plot.
Returned only if \code{graph_type="ggplot2"}. } Plots the cost-effectiveness
plane with a scatterplot of all the simulated values from the (posterior)
bivariate distribution of (\eqn{\Delta_e, \Delta_c}), the differentials of
effectiveness and costs; superimposes a contour of the distribution and
prints the value of the ICER, together with the sustainability area.
}
\description{
Produces a scatterplot of the cost-effectiveness plane, with a contour-plot
of the bivariate density of the differentials of cost (y-axis) and
effectiveness (x-axis).  Also adds the sustainability area (i.e. below the
selected value of the willingness-to-pay threshold).
}
\examples{
## create the bcea object m for the smoking cessation example
data(Smoking)
m <- bcea(eff, cost, ref = 4, interventions = treats, Kmax = 500)

## produce the plot
contour2(m,
         wtp = 200,
         graph_type = "base")

\donttest{
## or use ggplot2 to plot multiple comparisons
contour2(m,
         wtp = 200,
         ICER_size = 2,
         graph_type = "ggplot2")
}

## vaccination example
data(Vaccine)
treats = c("Status quo", "Vaccination")
m <- bcea(eff, cost, ref = 2, interventions = treats, Kmax = 50000)
contour2(m)
contour2(m, wtp = 100)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=ceplane.plot]{ceplane.plot()}},
\code{\link[=contour]{contour()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
