% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestforest.R
\name{BESTForest}
\alias{BESTForest}
\title{Generates a random forest of BEST trees}
\usage{
BESTForest(Data, VA, NoT = 50, Size = 50)
}
\arguments{
\item{Data}{A data set (Data Frame): Can take on both numerical and categorical predictors. Last column of the data set must be the Repsonse Variable (Categorical Variables only)}

\item{VA}{Variable Availability structure}

\item{NoT}{Number of Trees in the bag}

\item{Size}{Minimal Number of Observation within a leaf needed for partitionning (default is 50)}
}
\value{
A list of BEST Objects (Random Forest)
}
\description{
Generates a random forest of BEST trees
}
\examples{
n <- 500
Data <- BESTree::Data[1:n,]
d <- ncol(Data)-1
VA <- ForgeVA(d,1,0,0,0)
Size <- 50
NoT <- 10
Fit <- BESTree::BESTForest(Data,VA,NoT,Size)
}
