% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateCIs.R
\name{calculateCIs}
\alias{calculateCIs}
\title{Confidence Intervals for Correlations with Optional Design-Effect Adjustment}
\usage{
calculateCIs(
  tbl,
  rho_var,
  se_var,
  doubleentered = FALSE,
  method = "raykov",
  adjust_base = 1,
  design_effect_m = NULL,
  design_effect_rho = NULL,
  design_effect_m_col = NULL,
  design_effect_rho_col = NULL,
  conf_level = 0.95
)
}
\arguments{
\item{tbl}{A data frame or tibble containing the correlation coefficient and standard error variables.}

\item{rho_var}{The name of the column in \code{tbl} that contains the correlation coefficients.}

\item{se_var}{The name of the column in \code{tbl} that contains the standard errors.}

\item{doubleentered}{Logical. If \code{TRUE}, the function assumes that the correlation coefficients are double-entered, which adjusts the standard errors accordingly. Default is \code{FALSE}.}

\item{method}{Character; CI method selector. Supported values:
\itemize{
  \item \code{"raykov"} — Fisher \eqn{r \rightarrow z} CI (back-transformed).
  \item \code{"fisherz"} — alias of \code{"raykov"}.
  \item \code{"wald"} — Wald CI on the \eqn{r} scale.
  \item \code{"doubleentered"} — like \code{"raykov"} and, if
        \code{doubleentered} was not explicitly provided, it is set to
        \code{TRUE} (applies the \eqn{\sqrt{2}} multiplier).
  \item \code{"doubleenteredconserv"} — like \code{"wald"} and, if
        \code{doubleentered} was not explicitly provided, it is set to
        \code{TRUE}.
}}

\item{adjust_base}{A numeric value to adjust the standard errors. Default is 1.}

\item{design_effect_m}{A numeric value for the design effect related to the mean. Default is \code{NULL}.}

\item{design_effect_rho}{A numeric value for the design effect related to the correlation. Default is \code{NULL}.}

\item{design_effect_m_col}{A character string specifying the column name for the design effect related to the mean. Default is \code{NULL}.}

\item{design_effect_rho_col}{A character string specifying the column name for the design effect related to the correlation. Default is \code{NULL}.}

\item{conf_level}{The confidence level for the intervals. Default is 0.95.}
}
\value{
A modified version of \code{tbl} with additional columns for the confidence intervals and related statistics.
Everything uses adjusted standard errors, including confidence intervals, z-tests, and p-values.
}
\description{
Compute confidence intervals (CIs) for correlation coefficients using either
Fisher's \eqn{r \rightarrow z} approach (Raykov-style on the \eqn{z} scale) or
a Wald CI on the \eqn{r} scale. Standard errors are first **adjusted** by a
design-effect factor when available, and optionally for double entry.
The adjusted standard errors are used for all calculations, including CIs, z-tests, and p-values.
}
\note{
Double-entry handling and design effects are governed by
  \code{doubleentered}, \code{design_effect_m}/\code{design_effect_rho}
  (or their \code{*_col} variants), and \code{adjust_base}. The
  \code{"doubleentered*"} method values simply provide convenient aliases:
  they toggle \code{doubleentered} to \code{TRUE} only when the user hasn't
  explicitly set it, and map to \code{"raykov"} or \code{"wald"} as described.
}
\examples{
tbl <- data.frame(rho = c(0.5, 0.7, 0.3), se = c(0.1, 0.2, 0.05))
calculateCIs(tbl, rho_var = "rho", se_var = "se", method = "raykov")

}
