% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLinks.R
\name{process_one}
\alias{process_one}
\title{Convert Sparse Relationship Matrices to Kinship Links for one Matrix}
\usage{
process_one(
  matrix,
  rel_name,
  ids,
  nc,
  rel_pairs_file,
  writetodisk,
  write_buffer_size,
  drop_upper_triangular,
  update_rate,
  verbose,
  gc,
  include_all_links = TRUE,
  ...
)
}
\arguments{
\item{rel_pairs_file}{File path to write related pairs to (CSV format).}

\item{writetodisk}{Logical. If TRUE, writes the related pairs to disk; if FALSE, returns a data frame.}

\item{write_buffer_size}{Number of related pairs to write to disk at a time.}

\item{drop_upper_triangular}{Logical. If TRUE, drops the upper triangular portion of the matrix.}

\item{update_rate}{Numeric. Frequency (in iterations) at which progress messages are printed.}

\item{verbose}{Logical. If TRUE, prints progress messages.}

\item{gc}{Logical. If TRUE, performs garbage collection via \code{\link{gc}} to free memory.}

\item{include_all_links}{Logical. If TRUE, all links are included in the output.}

\item{...}{Additional arguments to be passed to \code{\link{com2links}}}
}
\description{
Convert Sparse Relationship Matrices to Kinship Links for one Matrix
}
\keyword{internal}
