% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_shapefile_to_skinny}
\alias{BIEN_ranges_shapefile_to_skinny}
\title{Extract range data and convert to smaller "skinny" format}
\usage{
BIEN_ranges_shapefile_to_skinny(directory, raster, skinny_ranges_file = NULL)
}
\arguments{
\item{directory}{The directory where range shapefiles will be stored.  If NULL, a temporary directory will be used.}

\item{raster}{A raster (which must have a CRS specified) to be used for rasterizing the ranges.}

\item{skinny_ranges_file}{A filename that will be used to write the skinny ranges will be written to (RDS format).  If NULL, this will not be written.}
}
\value{
Matrix containing 2 columns: 1) Species name; and 2) the raster cell number it occurs within.
}
\description{
BIEN_ranges_shapefile_to_skinny converts ranges to a "skinny" format to save space.
}
\examples{
\dontrun{
BIEN_ranges_shapefile_to_skinny(directory = BIEN_ranges_species_bulk(species = c("Acer rubrum")),
raster = terra::rast(crs = "+proj=laea +lat_0=15 +lon_0=-80 +x_0=0 +y_0=0 +datum=WGS84 
+units=m +no_defs +ellps=WGS84 +towgs84=0,0,0",
           extent = terra::ext(c(-5261554,5038446,-7434988,7165012 )),
           resolution =c(100000,100000)
           )
)
}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_box}()},
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_intersect_species}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_sf}()},
\code{\link{BIEN_ranges_skinny_ranges_to_richness_raster}()},
\code{\link{BIEN_ranges_species}()},
\code{\link{BIEN_ranges_species_bulk}()}
}
\concept{range functions}
